<?php

/**
 * Fired during plugin activation
 *
 * @link       https://iqonic.design/
 * @since      1.5.1
 *
 * @package    Marvy_Pro_Animation_Addons
 * @subpackage Marvy_Pro_Animation_Addons/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.5.1
 * @package    Marvy_Pro_Animation_Addons
 * @subpackage Marvy_Pro_Animation_Addons/includes
 * @author     Iqonic Design <hello@iqonic.design>
 */
class Marvy_Pro_Animation_Addons_Activator
{

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.5.1
     */
    public static function activate()
    {
        set_transient('marvy_animation_pro', '1', 0);
        update_option('MarvyPro_is_install',1);
        $options = get_option('marvy_option_settings');
        if(!$options){
            update_option('marvy_option_settings',[]);
        }
        return true;
    }
}
